package com.agilex.healthcare.veteranappointment.utils;

import com.agilex.healthcare.utility.NullChecker;
import edu.emory.mathcs.backport.java.util.Arrays;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

@Component(value="pilotFacilitiesHelper")
public class PilotFacilitiesHelper {

	public List<String> getPilotSites() {
		return getPilotSites(null);
	}

	@SuppressWarnings("unchecked")
	public List<String> getPilotSites(String appName) {
		List<String> pilotSitesList = null;

		String key = null;
		if (NullChecker.isNotNullish(appName)) {
			key = String.format("facilities.%s.pilotSites", appName.toLowerCase().trim());
		}

		if (key != null) {
			String pilotSites = System.getenv(key);

			if (NullChecker.isNotNullish(pilotSites)) {
				String[] pilotSitesArray = pilotSites.split(",");
				pilotSitesList = (List<String>) Arrays.asList(pilotSitesArray);
			}
		}

		return pilotSitesList;
	}
}
